  zeitfunkt.inc : Modulare_Parameter, Datums-und Zeitfunktionen
  2013-08-21  Verf.: Eger
  |MDOC
  |&-------------------------------------------------------------------------
  |* 	Modulare_Parameter    Datums-_und_Zeitfunktionen
  |$	MP_Date2Sort          V_2.00 2013-08-21
  |--------------------------------------------------------------------------
  | (C)     Anando Eger 2010-2014
:MP_Date2Sort
 ----------------------------------------------------------------------------
  | FKT:    wandelt Datumsformat von [T]T.[M]M.[JJ]JJ in JJJJMMTT
  |         2-stell. Jahreszahl wird in Bereich zw. 1980 und 2079 transform.
  |
  | DESC:   Das Datum wird formal gewandelt; es erfolgt keine Prfung auf 
  |         Zulssigkeit des Tags im Monat
  |
  | IN:     iv - zu wandelnde Zeichenkette
  |         $fMP_Mes - wenn gesetzt, interakt. Fehlerausgabe
  |
  | OUT:    iv - umgewandelte Zeichenkette
  |         leer, Wenn Fehler (ausserhalb 01.01.1000 bis 31.12.9999)
  |         in $vMP_Err steht dann der Fehlertext
  |
  | VAR:    #u0,#u1,#uz veraendert
  |&-------------------------------------------------------------------------
var (f" ")\ins #u0
if #uDF var "MP_Date2Sort(" #u0 ")";mes
var z\ins #uz
  | Tag prfen
var #u0(e".")\z =
if z<1 jump MP_Date2Sort_ERR
if z>31 jump MP_Date2Sort_ERR
var z\ins #u1
if <10 var "0" #u1
ins #u1\if #uDF mes
  | Monat prfen
var #u0(b"." f" " e".")\z =
if z<1 jump MP_Date2Sort_ERR
if z>12 jump MP_Date2Sort_ERR
var z\ins #u2
if <10 var "0" #u2
ins #u2\if #uDF mes
  | Jahr prfen
var #u0(b"." b"." f" " e" ")\z =
if z>999 jump MP_Date2Sort_1
if z>99 jump MP_Date2Sort_ERR
if z<80 z +2000;jump MP_Date2Sort_2
z +1900\jump MP_Date2Sort_2

:MP_Date2Sort_1
if z >9999 jump MP_Date2Sort_ERR

:MP_Date2Sort_2
if #uDF var z;mes
var z #u2 #u1\jump MP_Date2Sort_Ende

:MP_Date2Sort_ERR
var "MP_Date2Sort-Fehler: "
var +"Es wurde ein Datum im Format [T]T.[M]M.[JJ]JJ erwartet." n
var +"bergeben wurde: " #u0
ins $vMP_Err
if $fMP_Mes mes
var ""

:MP_Date2Sort_Ende
ins $T2S\var #uz\z=
#u0
#u1
#u2
#u3
#uz
var $T2S
return\mes return-Fehler: MP_Date2Sort\end

  |--------------------------------------------------------------------------
  |$	MP_Sort2Date			V_2.00
  |&-------------------------------------------------------------------------
:MP_Sort2Date
  |--------------------------------------------------------------------------
  | FKT: 	wandelt Datumsformat von JJJJMMTT in [T]T.[M]M.[JJ]JJ 
  | IN:  	iv - zu wandelnde Zeichenkette
  | OUT: 	iv - umgewandelte Zeichenkette
  |          	leer, Wenn Fehler 
  | VAR: 	#u1
  | DATE:	2007-03-28
  |&-------------------------------------------------------------------------


if <10000101 var ""
if >99991231 var ""
ins #u1
if #u1 var #u1(6,2) "." #u1(4,2) "." #u1(0,4)
#u1  
return\mes return-Fehler: MP_Sort2Date\end

  |--------------------------------------------------------------------------
  |$	MP_IsDate			V_2.00
  |&-------------------------------------------------------------------------
:MP_IsDate
  |-------------------------------------------------------------------------
  | Fkt:	Datumsangaben normalisieren
  | IN:	in iv wird folgende Datums-Form erwartet
  | 		[t]t.[m]m.jjjj
  | 		[t]t.-[t]t.[m]m.jjjj
  | 		[t]t.[m]m.-[t]t.[m]m.jjjj
  |
  | OUT:	iv wird normalisiert in
  | 		[t]t.[m]m.jjjj
  | 		oder
  | 		[t]t.[m]m.-tt.mm.jjjj
  |
  | 		wenn die Eingangszeichenkette nicht dem Schema entspricht,
  | 		wird "" zurckgegeben
  |
  | Var:	#ud1, #ud2 
  |		$tag, $monat, $jahr
  |		$etag, $emonat, $ejahr
  |		$isdate
  |		$isDate_z
  | Date:	2010-11-11
  |&------------------------------------------------------------------------

ins $isdate\var (e"-" f" " F" ")\ins #ud1
var $isdate\var (b"-" f" " F" ")\ins #ud2
var z\ins $isDate_z

var #ud1(f"[ abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ^/\\.,:;#+*-]")
ins #ud1\var #ud1(e"." f" " F" ")\ins $tag\if "" jump IsDate_End
var $tag\z=\if z<1 jump IsDate_Err
if #ud2 jump IsDate_Voll

  | nur einzelner Tag
var #ud1(b"." e"." f" " F" ")\ins $monat\if "" jump IsDate_TestJahr
var $monat\z=\if z<1 jump IsDate_Err

:IsDate_TestJahr
var #ud1(b"." b"." f" " e" " )\ins $jahr\if "" jump IsDate_1TagEnde
var $jahr\if %.% jump IsDate_Err
var $jahr\z=\if z<1 jump IsDate_Err

:IsDate_1TagEnde
var $isDate_z\z=
var $tag 
if $monat var +"." $monat 
if $jahr var +"." $jahr
jump IsDate_End

:IsDate_Voll
var #ud1(b"." e"." f" " F" ")\ins $monat
var #ud2(e"." f" " F" ")\ins $etag\if "" jump IsDate_End
var #ud2(b"." e"." f" " F" ")\ins $emonat\if "" jump IsDate_End
var #ud2(b"." b"." f" " e" " )\ins $ejahr\if "" jump IsDate_End

if $monat var $monat ".";ins $monat
var $isDate_z\z=
var $tag "." $monat "-" $etag "." $emonat "." $ejahr
jump IsDate_End

:IsDate_Err
var ""

:IsDate_End
ins $t\var $isDate_z\z=\var $t
return\mes return-Fehler MP_IsDate\end

  |--------------------------------------------------------------------------
  |$	MP_TimeDiff			V_2.00
  |&-------------------------------------------------------------------------
:MP_TimeDiff
 ----------------------------------------------------------------------------
  |FKT:         ermittelt Zeitdifferenz
  |IN:		iv: zwei Zeitangaben hh:mm:ss mit "-" getrennt
  |OUT:		Differenz in hh:mm:ss
  |VAR:
  |DATE:	2010-11-11
  |&-------------------------------------------------------------------------

ins $_TD\var Z\ins $_TDZ\var z\ins $_aeTDz

var $_TD\var (b"-")\ins $_TD2\var $_TD\var (e"-")\ins $_TD1
var (B":" B":")\Z=\var $_TD1\if not %:% jump _TD1
var (t":")\ins $_TD1\var (B":")\z=\z*60\var z\Z+\var $_TD1\if not %:% jump _TD1
var (e":")\z=\z*3600\var z\Z+

:_TD1
var Z0\ins $_TD1\var $_TD2
var (B":" B":")\Z=\var $_TD2\if not %:% jump _TD2
var (t":")\ins $_TD2\var (B":")\z=\z*60\var z\Z+\var $_TD2\if not %:% jump _TD2
var (e":")\z=\z*3600\var z\Z+

:_TD2
var $_TD1\Z-\if Z<0 Z*-1
  | Stunden berechnen
var Z\ins $_TD1\z=\z/3600\var z\ins $t\if <10 var "0" $t
ins $_TD2
  | Minuten berechnen
z*3600\var $_TD1\Z=\var z\Z-\var Z0\ins $_TD1\z=\z/60\var z\ins $t\if <10 var "0" $t
ins $t\var $_TD2 ":" $t\ins $_TD2
  | Sekunden bleiben brig
z*60\var $_TD1\Z=\var z\Z-\var Z0\ins $t\if <10 var "0" $t
ins $t\var $_TDZ\Z=\var $_aeTDz\z=\var $_TD2 ":" $t
return\mes MP_TimeDiff-Returnfehler\end

  |--------------------------------------------------------------------------
  |$	MP_TimeDiffSec			V_2.00
  |&-------------------------------------------------------------------------
:MP_TimeDiffSec
 ----------------------------------------------------------------------------
  |FKT:		ermittelt Zeitdifferenz in Sekunden
  |IN:		iv: zwei Zeitangaben hh:mm:ss mit "-" getrennt
  |             
  |OUT:		Differenz in Sekunden
  |VAR:
  |DATE:	2010-11-11
  |&-------------------------------------------------------------------------

ins $mp_TDS\var Z\ins $mp_TDZ\var z\ins $mp_TDz

var $mp_TDS\var (b"-")\ins $mp_TD2\var $mp_TDS\var (e"-")\ins $mp_TD1
var (B":" B":")\Z=\var $mp_TD1\if not %:% jump _TD1
var (t":")\ins $mp_TD1\var (B":")\z=\z*60\var z\Z+\var $mp_TD1\if not %:% jump _TD1
var (e":")\z=\z*3600\var z\Z+

:_TD1
var Z0\ins $mp_TD1\var $mp_TD2
var (B":" B":")\Z=\var $mp_TD2\if not %:% jump _TD2
var (t":")\ins $mp_TD2\var (B":")\z=\z*60\var z\Z+\var $mp_TD2\if not %:% jump _TD2
var (e":")\z=\z*3600\var z\Z+

:_TD2
var $mp_TD1\Z-\if Z<0 Z*-1\var Z0\ins $mp_TDS
var $mp_TDZ\Z=
var $mp_TDz\z=
var $mp_TDS
return\mes MP_TimeDiffSec-Returnfehler\end

  |--------------------------------------------------------------------------
  |$	MP_Time2Sec			V_2.00
  |&-------------------------------------------------------------------------
:MP_Time2Sec
 ----------------------------------------------------------------------------
  |FKT:		liefert Zeit in Sekunden
  |IN:		iv: Zeitangabe in hh:mm:ss
  |OUT:		Wert in Sekunden ab 00:00:00 Uhr
  |VAR:		$mp_T2S
  |DATE:	2010-11-11
  |&-------------------------------------------------------------------------

ins $mp_T2S\var Z\ins $mp_T2Z\var z\ins $mp_T2z

var $mp_T2S
var (B":" B":")\Z=\var $mp_T2S\if not %:% jump _T2S1
var (t":")\ins $mp_T2S\var (B":")\z=\z*60\var z\Z+\var $mp_T2S\if not %:% jump _T2S1
var (e":")\z=\z*3600\var z\Z+

:_T2S1
var Z0\ins $mp_T2S
var $mp_T2Z\Z=
var $mp_T2z\z=
var $mp_T2S
return\mes MP_Time2Sec-Returnfehler\end


  |--------------------------------------------------------------------------
  |$	MP_Sec2Time			V_2.00
  |&-------------------------------------------------------------------------
:MP_Sec2Time
 ----------------------------------------------------------------------------
  |FKT:		liefert Zeit in hh:mm:ss
  |IN:		iv: Zeitangabe in Sekunden ab 00:00:00 Uhr
  |OUT:		Zeit in hh:mm:ss
  |VAR:
  |DATE:	2008-08-25
  |&-------------------------------------------------------------------------
  | Stunden berechnen
ins $mp_S2T\var Z\ins $_T2Z\var z\ins $_T2z
var $mp_S2T\z=\z/3600\var z\ins $t\if <10 var "0" $t
ins $mp_S2Tt
  | Minuten berechnen
z*3600\var $mp_S2T\Z=\var z\Z-\var Z0\ins $mp_S2T\z=\z/60\var z\ins $t\if <10 var "0" $t
ins $t\var $mp_S2Tt ":" $t\ins $mp_S2Tt
  | Sekunden bleiben brig
z*60\var $mp_S2T\Z=\var z\Z-\var Z0\ins $t\if <10 var "0" $t
ins $t\var $mp_S2Tt ":" $t\ins $mp_S2T
var $_T2Z\Z=
var $_T2z\z=
var $mp_S2T
return\mes $mp_Sec2Time-Returnfehler\end

  |--------------------------------------------------------------------------
  |$	MP_TimeRemain			V_2.23
  |&-------------------------------------------------------------------------
:MP_TimeRemain
 ----------------------------------------------------------------------------
  | FKT:    Restzeit eines Prozesses ermitteln
  |
  | IN:     iv: Startzeit;akt_Zeit;Nmax;Nakt
  |         Beispiel: 10:23;11:11;200;75
  |
  | OUT:    Restzeit in [[hh:]mm:]ss; wenn unbestimmt, dann "?"
  |
  | VAR:    $mp_TR, $mp_TRZ, $mp_TRz als Zwischenspeicher
  |         $mp_TR1   - Startzeit
  |         $mp_TR2   - akt. Zeit
  |         $mp_TRMax - max. Anzahl
  |         $mp_TRAct - akt. Anzahl
  |
  | DATE:	2014-05-30
  |&-------------------------------------------------------------------------
  |COST:	120
  
  +--------------------------------------------------------------------------
  | z-Variablen retten
ins $mp_TR\var Z\ins $mp_TRZ\var z\ins $mp_TRz

  |--------------------------------------------------------------------------
  | Parameter aufbereiten
var $mp_TR\var (b";" b";" e";")\ins $mp_TRMax
var $mp_TR\var (b";" b";" b";")\ins $mp_TRAct\z=\if z=0 var "?";jump MP_TREnd
var $mp_TR\var (b";" e";")\ins $mp_TR2\var $mp_TR\var (e";")\ins $mp_TR1

  |--------------------------------------------------------------------------
  | Startzeit in s umrechnen 
var (B":" B":")\Z=\var $mp_TR1\if not %:% jump MP_TR1
var (t":")\ins $mp_TR1\var (B":")\z=\z*60\var z\Z+
var $mp_TR1\if not %:% jump MP_TR1
var (e":")\z=\z*3600\var z\Z+

:MP_TR1
var Z0\ins $mp_TR1
  |--------------------------------------------------------------------------
  | akt. Zeit in s umrechnen und Differenz zu Startzeit ermitteln
var $mp_TR2
var (B":" B":")\Z=\var $mp_TR2\if not %:% jump MP_TR2
var (t":")\ins $mp_TR2\var (B":")\z=\z*60\var z\Z+
var $mp_TR2\if not %:% jump MP_TR2
var (e":")\z=\z*3600\var z\Z+

:MP_TR2
var $mp_TR1\Z-\if Z<0 Z*-1\var Z0\ins $mp_TRDiff
  
  |--------------------------------------------------------------------------
  | Rest = (TLDiff * TLMax / TLAct) -TLDiff
var $mp_TRMax\Z*\var $mp_TRAct\Z/\var $mp_TRDiff\Z-\var Z0\z=
  | Stunden ausrechnen
var ""\ins $mp_TRt\z/3600\if z=0 jump MP_TR3
  | Anzahl der Stunden
var z "h"\ins $mp_TRt
  | verarbeitete Zahl abziehen
z*3600\var z\Z-

:MP_TR3
var Z0\z=\z/60\if z=0 jump MP_TR4
var z\ins $t\if <10 var "0" $t
var +"m"\ins $t\if $mp_TRt var $mp_TRt ":" $t\ins $mp_TRt
z*60\var z\Z-

:MP_TR4
var Z0\ins $t\if <10 var "0" $t;ins $t
if $mp_TRt var $mp_TRt ":" $t

:MP_TREnd
var +"s"\ins $mp_TR

var $mp_TRZ\Z=\var $mp_TRz\z=
var $mp_TR\ins _0-0_0_
return\mes MP_TimeLeft Returnfehler\end

  |--------------------------------------------------------------------------
  |$	MP_PercRemain			V_2.00
  |&-------------------------------------------------------------------------
:MP_PercRemain
 ----------------------------------------------------------------------------
  |FKT:		prozentualer Restanteil
  |IN:		iv: N-max;N-akt
  |OUT:		prozentualer Restwert; Format: nn.nn%
  |VAR:         $mp_PR, $mp_PRZ als Zwischenspeicher
  |DATE:	2009-10-22
  |&-------------------------------------------------------------------------

ins $mp_PR\var Z\ins $mp_PRZ
var $mp_PR\var (b";")\ins $mp_PRAct
var $mp_PR\var (e";")\ins $mp_PRMax
var $mp_PRAct\Z=\Z*100\var $mp_PRMax\Z/
var Z2 "%"\ins $mp_PR

var $mp_PRZ\Z=
var $mp_PR
return\mes MP_PercRemain Returnfehler\end
  
 

